<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use Dotenv\Dotenv;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        api: __DIR__ . '/../routes/api.php',
        apiPrefix: 'api/',
        web: __DIR__ . '/../routes/web.php',
        commands: __DIR__ . '/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->validateCsrfTokens(except: [
            'stripe/*',
            'http://127.0.0.1:8000/store-loan-application',
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })
    ->create()
    ->useEnvironmentPath(__DIR__ . '/..') // Set the environment path
    ->loadEnvironmentFrom(file_exists(__DIR__ . '/../.env.local') ? '.env.local' : '.env');
