<div class="p-4">
    <h2 class="text-xl font-bold mb-4">All Payments</h2>

    <div class="mb-4">
        <label>Start Date:</label>
        <input type="date" wire:model="startDate">
        <label>End Date:</label>
        <input type="date" wire:model="endDate">
        <button wire:click="$refresh">Filter</button>
    </div>

    <table border="1" cellpadding="5" class="w-full text-left">
        <thead>
            <tr>
                <th>ID</th>
                <th>User</th>
                <th>Loan Amount</th>
                <th>Payment Amount</th
<th>Amount Due</th>
>
                <th>Payment Date</th>
            </tr>
        </thead>
        <tbody>
            @foreach($payments as $payment)
            <tr>
                <td>{{ $payment->id }}</td>
                <td>{{ $payment->user_name }}</td>
                <td>{{ $payment->loan_amount }}</td>
                <td>{{ $payment->amount }}</td>
<td>{{ number_format($payment->amount_due ?? 0) }}</td>

                <td>{{ $payment->payment_date }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div class="mt-4">
        {{ $payments->links() }}
    </div>
</div>
