<div class="p-6 bg-white text-gray-700 space-y-10">

    
    <div class="flex flex-wrap items-center gap-4">
        
    </div>

    
    <div>
        <h2 class="text-xl font-semibold mb-2">Upcoming Repayments (Next 7 Days)</h2>
        
        
        <input type="text" id="searchUpcoming" placeholder="Search Upcoming Repayments..." class="border rounded p-2 mb-2 w-full">

        <div class="overflow-auto border border-gray-300 rounded">
            <table class="min-w-full text-sm">
                <thead class="bg-gray-700 text-white">
                    <tr>
                        <th class="text-left px-4 py-2">Customer</th>
                        <th class="text-left px-4 py-2">Due Date</th>
                        <th class="text-left px-4 py-2">Amount Due</th>
                        <th class="text-left px-4 py-2">Reminders</th>
                    </tr>
                </thead>
                <tbody id="upcomingTable">
                    <?php $__empty_1 = true; $__currentLoopData = $upcomingRepayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="border-t">
                            <td class="px-4 py-2"><?php echo e($loan->applicant_name); ?></td>
                            <td class="px-4 py-2"><?php echo e($loan->due_date->toDateString()); ?></td>
                            <td class="px-4 py-2"><?php echo e(number_format($loan->amount_due, 2)); ?></td>
                            <td class="px-4 py-2">
                                <?php $__currentLoopData = ['before', 'on', 'after']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($loan->reminders->has($type)): ?>
                                        <span class="inline-block text-xs px-2 py-1 border rounded border-gray-700"><?php echo e($type); ?></span>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="4" class="px-4 py-2">No upcoming repayments.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    
    <div>
        <h2 class="text-xl font-semibold mb-2">Missed Repayments</h2>

        
        <input type="text" id="searchMissed" placeholder="Search Missed Repayments..." class="border rounded p-2 mb-2 w-full">

        <div class="overflow-auto border border-gray-300 rounded">
            <table class="min-w-full text-sm">
                <thead class="bg-gray-700 text-white">
                    <tr>
                        <th class="text-left px-4 py-2">Customer</th>
                        <th class="text-left px-4 py-2">Due Date</th>
                        <th class="text-left px-4 py-2">Amount Due</th>
                        <th class="text-left px-4 py-2">Days Overdue</th>
                        <th class="text-left px-4 py-2">Reminders</th>
                    </tr>
                </thead>
                <tbody id="missedTable">
                    <?php $__empty_1 = true; $__currentLoopData = $missedRepayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="border-t">
                            <td class="px-4 py-2"><?php echo e($loan->applicant_name); ?></td>
                            <td class="px-4 py-2"><?php echo e($loan->due_date?->format('Y-m-d') ?? '-'); ?></td>
                            <td class="px-4 py-2"><?php echo e(number_format($loan->amount_due, 2)); ?></td>
                            <td class="px-4 py-2"><?php echo e($loan->days_overdue); ?></td>
                            <td class="px-4 py-2">
                                <?php if($loan->reminder_after): ?>
                                    <span class="inline-block text-xs px-2 py-1 border rounded border-gray-700">after</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="px-4 py-2 text-center text-gray-500">No missed repayments.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    
    <div>
        <div class="flex justify-between items-center mb-2">
            <h2 class="text-xl font-semibold">Reminder Logs</h2>
            <button wire:click="exportReminderLogs" class="text-sm px-4 py-1 border border-gray-700 rounded bg-white hover:bg-gray-100">Export</button>
        </div>

        
        <input type="text" id="searchLogs" placeholder="Search Reminder Logs..." class="border rounded p-2 mb-2 w-full">

        <div class="overflow-auto border border-gray-300 rounded">
            <table class="min-w-full text-sm">
                <thead class="bg-gray-700 text-white">
                    <tr>
                        <th class="text-left px-4 py-2">Customer</th>
                        <th class="text-left px-4 py-2">Loan ID</th>
                        <th class="text-left px-4 py-2">Status</th>
                        <th class="text-left px-4 py-2">Reason</th>
                        <th class="text-left px-4 py-2">Sent At</th>
                    </tr>
                </thead>
                <tbody id="logsTable">
                    <?php $__empty_1 = true; $__currentLoopData = $sms_logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="border-t">
                            <td class="px-4 py-2"><?php echo e($log->applicant_name ?? '-'); ?></td>
                            <td class="px-4 py-2"><?php echo e($log->loan_id); ?></td>
                            <td class="px-4 py-2"><?php echo e(ucfirst($log->sent_status) ?? '-'); ?></td>
                            <td class="px-4 py-2"><?php echo e($log->reason ?? '-'); ?></td>
                            <td class="px-4 py-2"><?php echo e(\Carbon\Carbon::parse($log->sent_at)->format('Y-m-d H:i')); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="px-4 py-2">No reminder logs found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>


<script>
function filterTable(inputId, tableId) {
    const input = document.getElementById(inputId);
    const filter = input.value.toUpperCase();
    const rows = document.querySelectorAll(`#${tableId} tr`);
    rows.forEach(row => {
        row.style.display = row.textContent.toUpperCase().includes(filter) ? '' : 'none';
    });
}

document.getElementById('searchUpcoming').addEventListener('keyup', () => filterTable('searchUpcoming', 'upcomingTable'));
document.getElementById('searchMissed').addEventListener('keyup', () => filterTable('searchMissed', 'missedTable'));
document.getElementById('searchLogs').addEventListener('keyup', () => filterTable('searchLogs', 'logsTable'));
</script>
<?php /**PATH /var/www/html/nkcng/resources/views/livewire/repayment-alerts-view.blade.php ENDPATH**/ ?>