<div class="bg-white dark:bg-gray-800 shadow-md sm:rounded-lg p-6 mt-6">
    <h3 class="text-lg font-medium text-gray-700 dark:text-gray-300 mb-4">Assign GPS Device</h3>

    <?php if($successMessage): ?>
        <div class="mb-4 p-4 bg-green-100 text-green-700 dark:bg-green-900 dark:text-green-300 rounded-lg">
            <?php echo e($successMessage); ?>

        </div>
    <?php endif; ?>

    <?php if($errorMessage): ?>
        <div class="mb-4 p-4 bg-red-100 text-red-700 dark:bg-red-900 dark:text-red-300 rounded-lg">
            <?php echo e($errorMessage); ?>

        </div>
    <?php endif; ?>

    <?php if($statusMessage): ?>
        <div class="mb-4 p-4 bg-yellow-100 text-yellow-700 dark:bg-yellow-900 dark:text-yellow-300 rounded-lg">
            <?php echo e($statusMessage); ?>

            <?php if($installationPending): ?>
                <a href="/approve-installation/<?php echo e($installationId); ?>"
                    class="mt-2 inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-gray-600 hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gray-500">
                    Approve Installation
                </a>
            <?php endif; ?>
        </div>
    <?php endif; ?>

    <?php if($canAssign): ?>
        <form wire:submit.prevent="assignDevice" class="space-y-4">
            <div>
                <label for="device" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Select GPS Device</label>
                <select wire:model="selectedDeviceId" id="device"
                    class="mt-1 block w-full py-2 px-3 border border-gray-300 bg-white dark:bg-gray-700 dark:border-gray-600 dark:text-white rounded-md shadow-sm focus:outline-none focus:ring-gray-500 focus:border-gray-500 sm:text-sm">
                    <option value="">Select a device...</option>
                    <?php $__currentLoopData = $devices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deviceId => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($deviceId); ?>"><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['selectedDeviceId'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 dark:text-red-400 text-sm"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div>
                <label for="vehicle" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Select Vehicle (Optional)</label>
                <select wire:model="selectedVehicleId" id="vehicle"
                    class="mt-1 block w-full py-2 px-3 border border-gray-300 bg-white dark:bg-gray-700 dark:border-gray-600 dark:text-white rounded-md shadow-sm focus:outline-none focus:ring-gray-500 focus:border-gray-500 sm:text-sm">
                    <option value="">No vehicle selected</option>
                    <?php $__currentLoopData = $vehicles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vehicleId => $plateNumber): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($vehicleId); ?>"><?php echo e($plateNumber); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['selectedVehicleId'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="text-red-500 dark:text-red-400 text-sm"><?php echo e($errors->first('selectedVehicleId')); ?></span>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div>
                <button type="submit"
                    class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-gray-600 hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gray-500">
                    Assign Device
                </button>
            </div>
        </form>

        <?php if(empty($devices)): ?>
            <p class="mt-4 text-gray-500 dark:text-gray-400">No unassigned GPS devices available.</p>
        <?php endif; ?>
    <?php endif; ?>
</div>
<?php /**PATH /var/www/html/nkcng/resources/views/livewire/assign-gps-device.blade.php ENDPATH**/ ?>