<div class="p-4">
    <h2 class="text-xl font-bold mb-4">All Payments</h2>

    <div class="mb-4">
        <label>Start Date:</label>
        <input type="date" wire:model="startDate">
        <label>End Date:</label>
        <input type="date" wire:model="endDate">
        <button wire:click="$refresh">Filter</button>
    </div>

    <table border="1" cellpadding="5" class="w-full text-left">
        <thead>
            <tr>
                <th>ID</th>
                <th>User</th>
                <th>Loan Amount</th>
                <th>Payment Amount</th
<th>Amount Due</th>
>
                <th>Payment Date</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($payment->id); ?></td>
                <td><?php echo e($payment->user_name); ?></td>
                <td><?php echo e($payment->loan_amount); ?></td>
                <td><?php echo e($payment->amount); ?></td>
<td><?php echo e(number_format($payment->amount_due ?? 0)); ?></td>

                <td><?php echo e($payment->payment_date); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div class="mt-4">
        <?php echo e($payments->links()); ?>

    </div>
</div>
<?php /**PATH /var/www/html/nkcng/resources/views/livewire/all-payments-component.blade.php ENDPATH**/ ?>