<div x-data="{ open: false }" class="bg-white shadow rounded mb-2">
    <!-- Header -->
    <button @click="open = !open" class="w-full text-left px-4 py-3 flex justify-between items-center focus:outline-none">
        <div>
            <span class="font-semibold text-gray-700">Loan #<?php echo e($loan->id); ?></span>
            <span class="text-sm text-gray-500 ml-2"><?php echo e($loan->loan_end_date ? \Carbon\Carbon::parse($loan->loan_end_date)->format('d M, Y') : 'No End Date'); ?></span>
        </div>
        <svg :class="{ 'rotate-180': open }" class="w-5 h-5 transition-transform duration-200" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
        </svg>
    </button>

    <!-- Collapse content -->
    <div x-show="open" x-transition class="px-4 py-3 border-t border-gray-200">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <p><span class="font-semibold">Borrower:</span> <?php echo e($loan->user->first_name); ?> <?php echo e($loan->user->last_name); ?></p>
                <p><span class="font-semibold">Amount Requested:</span> <?php echo e(number_format($loan->loan_required_amount, 2)); ?></p>
                <p><span class="font-semibold">Status:</span> <?php echo e(ucfirst($loan->status)); ?></p>
            </div>
            <div>
                <p><span class="font-semibold">Interval:</span> <?php echo e($interval ?? 'N/A'); ?></p>
                <p><span class="font-semibold">Start Date:</span> <?php echo e($loan->loan_start_date ? \Carbon\Carbon::parse($loan->loan_start_date)->format('d M, Y') : 'N/A'); ?></p>
                <p><span class="font-semibold">End Date:</span> <?php echo e($loan->loan_end_date ? \Carbon\Carbon::parse($loan->loan_end_date)->format('d M, Y') : 'N/A'); ?></p>
            </div>
        </div>

        <?php if($loan->payments->count()): ?>
            <div class="mt-3">
                <h4 class="font-semibold text-gray-700 mb-1">Payments</h4>
                <ul class="list-disc list-inside text-gray-600">
                    <?php $__currentLoopData = $loan->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li>
                            <?php echo e(\Carbon\Carbon::parse($payment->payment_date)->format('d M, Y')); ?> - <?php echo e(number_format($payment->amount, 2)); ?>

                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php else: ?>
            <p class="mt-3 text-gray-500">No payments recorded yet.</p>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH /var/www/html/nkcng/resources/views/partials/loan-collapse.blade.php ENDPATH**/ ?>