<?php
    use Illuminate\Support\Str;
?>


<?php $__env->startSection('title', 'Approve Installation' . ' - ' . $installation->id); ?>

<?php $__env->startSection('main-content'); ?>
    <div class="wrapper wrapper-content animated fadeInRight">
        <div class="row">
            <div class="col-lg-12 flex justify-center ">
                <div class="ibox   bg-nkgreen shadow-md sm:rounded-lg w-full flex flex-col justify-center">
                    <div
                        class="ibox-content w-1/2 bg-white  dark:bg-gray-800 shadow-md sm:rounded-lg p-6 flex flex-col justify-center">
                        <h2 class="text-2xl font-semibold text-gray-900 dark:text-white mb-6">Approve Installation</h2>

                        <?php if(session('success')): ?>
                            <div
                                class="mb-4 p-4 bg-green-100 text-green-700 dark:bg-green-900 dark:text-green-300 rounded-lg">
                                <?php echo e(session('success')); ?>

                            </div>
                        <?php endif; ?>

                        <?php if($installation): ?>
                            <?php if($installation->status === 'completed'): ?>
                                <div
                                    class="mb-4 p-4 bg-yellow-100 text-yellow-700 dark:bg-yellow-900 dark:text-yellow-300 rounded-lg">
                                    This installation has already been completed.
                                </div>
                            <?php elseif($installation->status === 'pending'): ?>
                                <div class="mt-4">
                                    <div class="space-y-4 flex flex-col  justify-center">
                                        <div class="flex items-center ">
                                            <span class="w-1/3 font-medium text-gray-700 dark:text-gray-300">Installation
                                                ID:</span>
                                            <span class="text-gray-900 dark:text-white"><?php echo e($installation->id); ?></span>
                                        </div>
                                        <div class="flex items-center">
                                            <span class="w-1/3 font-medium text-gray-700 dark:text-gray-300">Vehicle:</span>
                                            <span
                                                class="text-gray-900 dark:text-white"><?php echo e($installation->customervehicle->plate_number ?? 'N/A'); ?></span>
                                        </div>
                                        <div class="flex items-center">
                                            <span class="w-1/3 font-medium text-gray-700 dark:text-gray-300">Cylinder
                                                Type:</span>
                                            <span
                                                class="text-gray-900 dark:text-white"><?php echo e($installation->cylinderType->name ?? 'N/A'); ?></span>
                                        </div>
                                        <div class="flex items-center">
                                            <span class="w-1/3 font-medium text-gray-700 dark:text-gray-300">Status:</span>
                                            <span
                                                class="text-gray-900 dark:text-white"><?php echo e(Str::title($installation->status)); ?></span>
                                        </div>
                                        <div class="flex items-center">
                                            <span class="w-1/3 font-medium text-gray-700 dark:text-gray-300">Payment
                                                Type:</span>
                                            <span
                                                class="text-gray-900 dark:text-white"><?php echo e(Str::title($installation->payment_type)); ?></span>
                                        </div>
                                    </div>

                                    <form action="<?php echo e(route('approve-installation.update', $installation->id)); ?>"
                                        method="POST" class="mt-6 space-y-4">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('POST'); ?>

                                        <div>
                                            <label for="status"
                                                class="block text-sm font-medium text-gray-700 dark:text-gray-300">Installation
                                                Status</label>
                                            <select name="status" id="status"
                                                class="mt-1 block w-[40%] py-2 px-3 border border-gray-300 bg-white dark:bg-gray-700 dark:border-gray-600 dark:text-white rounded-md shadow-sm focus:outline-none focus:ring-gray-500 focus:border-gray-500 sm:text-sm">
                                                <option value="pending"
                                                    <?php echo e($installation->status === 'pending' ? 'selected' : ''); ?>>Pending
                                                </option>
                                                <option value="completed"
                                                    <?php echo e($installation->status === 'completed' ? 'selected' : ''); ?>>Completed
                                                </option>
                                            </select>
                                            <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-red-500 dark:text-red-400 text-sm"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div>
                                            <button type="submit"
                                                class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-gray-600 hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gray-500">
                                                Update Installation
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            <?php endif; ?>
                        <?php else: ?>
                            <p class="text-red-500 dark:text-red-400">Installation not found.</p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/nkcng/resources/views/installations/approve-installation.blade.php ENDPATH**/ ?>