<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Weekly Financial Report</title>
</head>
<body style="font-family: Arial, sans-serif; background-color:#f6f6f6; margin:0; padding:20px;">

<table width="100%" cellpadding="0" cellspacing="0">
    <tr>
        <td align="center">
            <!-- Outer Table -->
            <table width="700" cellpadding="20" cellspacing="0" style="background-color:#ffffff; border-radius:6px; box-shadow:0 2px 5px rgba(0,0,0,0.1);">

                <!-- HEADER -->
                <tr>
                    <td>
                        <h2 style="margin:0 0 5px 0; color:#333; font-size:24px;">Weekly Financial Report</h2>
                        <p style="margin:0; color:#666; font-size:14px;">
                            Week: {{ $report['start_date'] }} to {{ $report['end_date'] }}
                        </p>
                        <p style="margin:3px 0 10px 0; color:#555; font-size:13px;">
                            Generated On: {{ now()->format('d/m/Y') }}
                        </p>
                    </td>
                </tr>

                <!-- OVERVIEW -->
                <tr>
                    <td style="padding-bottom:12px;">
                        <h3 style="color:#333; margin:0 0 5px 0; font-size:17px;">Report Overview</h3>
                        <p style="font-size:14px; color:#555; margin:0;">
                            This report provides a summary of all financial activities recorded during the selected week.
                        </p>
                    </td>
                </tr>

                <!-- DATA TABLE -->
                <tr>
                    <td>
                        <table width="100%" cellpadding="10" cellspacing="0" style="border-collapse:collapse; font-size:14px;">
                            <!-- Table Header -->
                            <tr style="background-color:#4a90e2; color:#ffffff;">
                                <th style="border:1px solid #ddd; padding:8px;">Metric</th>
                                <th style="border:1px solid #ddd; padding:8px;" align="right">Value</th>
                            </tr>

                            <!-- Total Amount -->
                            <tr>
                                <td style="border:1px solid #ddd; padding:8px;">Total Amount (money stack)</td>
                                <td align="right" style="border:1px solid #ddd; padding:8px; color:#2a9d8f; font-weight:bold;">
                                    {{ number_format($report['total_amount']) }} Tshs
                                </td>
                            </tr>

                            <!-- Paid Amount -->
                            <tr>
                                <td style="border:1px solid #ddd; padding:8px;">Paid Amount (money in)</td>
                                <td align="right" style="border:1px solid #ddd; padding:8px; color:#e76f51; font-weight:bold;">
                                    {{ number_format($report['paid_amount'], 2) }} Tshs
                                </td>
                            </tr>

                            <!-- Due Amount -->
                            <tr>
                                <td style="border:1px solid #ddd; padding:8px;">Due Amount (money out)</td>
                                <td align="right" style="border:1px solid #ddd; padding:8px; color:#f4a261; font-weight:bold;">
                                    {{ number_format($report['due_amount']) }} Tshs
                                </td>
                            </tr>

                            <!-- All Users -->
                            <tr>
                                <td style="border:1px solid #ddd; padding:8px;">All Users (customers with loans)</td>
                                <td align="right" style="border:1px solid #ddd; padding:8px;">
                                    {{ $report['all_users'] }} People
                                </td>
                            </tr>

                            <!-- Fully Paid -->
                            <tr>
                                <td style="border:1px solid #ddd; padding:8px;">Fully Paid Customers</td>
                                <td align="right" style="border:1px solid #ddd; padding:8px; color:#2a9d8f; font-weight:bold;">
                                    {{ $report['fully_paid'] }} People
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>

                <!-- OPTIONAL NOTES -->
                <tr>
                    <td style="font-size:13px; color:#e63946; padding-top:10px;">
                        @if($report['due_amount'] == 0)
                            All customers are up-to-date. No overdue payments this week.
                        @else
                            Some customers have pending dues. Please follow up accordingly.
                        @endif
                    </td>
                </tr>

                <!-- FOOTER -->
                <tr>
                    <td style="font-size:14px; color:#555; padding-top:12px;">
                        <p>Thanks,</p>
                        <p><strong>NKCNG</strong></p>
                    </td>
                </tr>

            </table>
            <!-- End Outer Table -->
        </td>
    </tr>
</table>

</body>
</html>

