@extends('layouts.app')

@section('content')
<div class="container mt-5" style="height: 90vh; display: flex; flex-direction: column;">
    <h2 class="mb-4">All Payments</h2>

    <!-- Filter Form -->
    <form method="GET" action="{{ route('all.payments') }}" class="row g-3 mb-3">
        <div class="col-md-4">
            <label for="start_date" class="form-label">Start Date</label>
            <input type="text" name="start_date" id="start_date" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off" readonly
                   value="{{ request('start_date') }}">
        </div>
        <div class="col-md-4">
            <label for="end_date" class="form-label">End Date</label>
            <input type="text" name="end_date" id="end_date" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off" readonly
                   value="{{ request('end_date') }}">
        </div>
        <div class="col-md-4 d-flex align-items-end">
            <button type="submit" class="btn btn-primary me-2">Filter</button>
            <a href="{{ route('all.payments') }}" class="btn btn-secondary">Reset</a>
        </div>
    </form>

    <!-- Search Bar -->
    <div class="mb-3">
        <input type="text" id="searchInput" class="form-control" placeholder="Search Client Name...">
    </div>

    <!-- Payments Table -->
    <div class="table-responsive flex-grow-1" style="overflow-y: auto; border: 1px solid #dee2e6; border-radius: 5px;">
        <table id="paymentsTable" class="table table-striped table-hover table-bordered mb-0" style="min-width: 900px; max-width: 95%;">
            <thead class="table-dark" style="position: sticky; top: 0; z-index: 10;">
                <tr>
                    <th>#</th>
                    <th>Client Name</th>
                    <th>Amount Paid (Tsh)</th>
                    <th>Amount Due (Tsh)</th> <!-- New column -->
                    <th>Payment Method</th>
                    <th>Status</th>
                    <th>Payment Date</th>
                </tr>
            </thead>
            <tbody>
                @foreach($payments as $payment)
                    @php
                        $loan = $payment->loan;
                        $amount_due = $loan->loan_required_amount - $payment->paid_amount;
                        $amount_due = max($amount_due, 0); // Ensure no negative
                        
                        if($payment->paid_amount >= $loan->loan_required_amount){
                            $loan_status = 'Completed';
                        } elseif(\Carbon\Carbon::parse($loan->loan_end_date)->isPast()){
                            $loan_status = 'Overdue';
                        } else {
                            $loan_status = 'Ongoing';
                        }
                    @endphp
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $loan->applicant_name ?? 'N/A' }}</td>
                        <td class="paid-amount">{{ number_format($payment->paid_amount, 2, '.', '') }}</td>
                        <td class="due-amount">{{ number_format($amount_due, 2, '.', '') }}</td> <!-- New cell -->
                        <td>{{ $payment->payment_method ?? 'N/A' }}</td>
                        <td>
                            @if($loan_status == 'Completed')
                                <span class="badge bg-success">{{ $loan_status }}</span>
                            @elseif($loan_status == 'Overdue')
                                <span class="badge bg-danger">{{ $loan_status }}</span>
                            @else
                                <span class="badge bg-warning text-dark">{{ $loan_status }}</span>
                            @endif
                        </td>
                        <td>{{ \Carbon\Carbon::parse($payment->payment_date)->format('d-m-Y') }}</td>
                    </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr class="table-secondary">
                    <th colspan="2" class="text-end">Total:</th>
                    <th id="grandTotalPaid">{{ number_format($payments->sum('paid_amount'), 2) }}</th>
                    <th id="grandTotalDue">{{ number_format($payments->sum(function($p){ return max($p->loan->loan_required_amount - $p->paid_amount, 0); }), 2) }}</th>
                    <th colspan="3"></th>
                </tr>
            </tfoot>
        </table>
    </div>
</div>

<!-- Include Flatpickr CSS/JS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

<script>
document.addEventListener('DOMContentLoaded', function () {
    flatpickr("#start_date", { dateFormat: "d/m/Y", allowInput: false });
    flatpickr("#end_date", { dateFormat: "d/m/Y", allowInput: false });

    const searchInput = document.getElementById('searchInput');
    const table = document.getElementById('paymentsTable').getElementsByTagName('tbody')[0];
    const totalPaidCell = document.getElementById('grandTotalPaid');
    const totalDueCell = document.getElementById('grandTotalDue');

    function updateTotals() {
        let rows = table.getElementsByTagName('tr');
        let totalPaid = 0;
        let totalDue = 0;
        for (let i = 0; i < rows.length; i++) {
            if (rows[i].style.display !== 'none') {
                const paid = parseFloat(rows[i].querySelector('.paid-amount').textContent.replace(/,/g, ''));
                const due = parseFloat(rows[i].querySelector('.due-amount').textContent.replace(/,/g, ''));
                totalPaid += paid;
                totalDue += due;
            }
        }
        totalPaidCell.textContent = totalPaid.toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2});
        totalDueCell.textContent = totalDue.toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2});
    }

    searchInput.addEventListener('keyup', function() {
        const filter = this.value.toLowerCase();
        const rows = table.getElementsByTagName('tr');
        for (let i = 0; i < rows.length; i++) {
            const clientCell = rows[i].getElementsByTagName('td')[1];
            if (clientCell) {
                rows[i].style.display = clientCell.textContent.toLowerCase().includes(filter) ? '' : 'none';
            }
        }
        updateTotals();
    });
});
</script>

@endsection

