<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Exception;
use Illuminate\Support\Facades\Log;

class TestDbConnection extends Command
{
    protected $signature = 'db:test-connection';
    protected $description = 'Test MySQL connection and fetch first 2 users';

    public function handle()
    {
        $this->info("🟢 Starting DB test..." );

        try {
            // Force fresh DB connection
            DB::purge('mysql');
            DB::reconnect('mysql');
            $pdo = DB::connection()->getPdo();

            // Increase session timeout to avoid connection drops
            DB::statement("SET SESSION wait_timeout=600;");
            DB::statement("SET SESSION interactive_timeout=600;");

            $this->info("✅ DB connected successfully.");

            // Fetch first 2 users safely
            $users = DB::table('users')
                ->select('first_name', 'last_name') // removed email
                ->limit(2)
                ->get();

            if ($users->isEmpty()) {
                $this->info("No users found.");
            } else {
                $this->info("First 2 users:");
                foreach ($users as $user) {
                    $fullName = trim($user->first_name . ' ' . $user->last_name);
                    $this->line("- " . $fullName);
                }
            }

        } catch (Exception $e) {
            $this->error("❌ DB test failed: " . $e->getMessage());
            Log::error('DB test error: ' . $e->getMessage());
        }

        return Command::SUCCESS;
    }
}

