<?php

if (!function_exists('isActive')) {
    /**
     * Return CSS class if route matches current path.
     *
     * @param string $route
     * @return string
     */
    function isActive($route)
    {
        $currentPath = request()->path();
        $routePath = trim($route, '/');
        return $currentPath === $routePath || str_starts_with($currentPath, $routePath . '/')
            ? 'bg-gray-700 !bg-gray-700'
            : '';
    }
}

