<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class WeeklyReportMail extends Mailable
{
    use Queueable, SerializesModels;

    public $report;

    public function __construct(array $report)
    {
        $this->report = $report;
    }

    public function build()
    {
        return $this->subject('Weekly Financial Report')
                    ->view('emails.weekly_report')
                    ->with('report', $this->report);
    }
}

