@extends('layouts.app')

@section('content')
<main class="p-6 space-y-6 bg-blue-100 min-h-screen">

    <!-- Header -->
    <div class="text-center mb-6">
        <h2 class="text-2xl font-bold">All Payments</h2>
        <div class="mt-2 flex justify-center gap-4">
            <input type="date" name="start_date" placeholder="Start Date" class="border rounded px-2 py-1">
            <input type="date" name="end_date" placeholder="End Date" class="border rounded px-2 py-1">
            <input type="text" name="client_name" placeholder="Search Client Name..." class="border rounded px-2 py-1">
            <button class="bg-blue-500 text-white px-4 py-1 rounded">Search</button>
        </div>
    </div>

    <!-- Payments Table -->
    <div class="overflow-x-auto bg-white rounded shadow">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-100">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">#</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Client Name</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Amount (Tsh)</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Amount Due</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Payment Method</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Payment Date</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @forelse($payments as $index => $payment)
                    <tr>
                        <td class="px-6 py-4">{{ $index + 1 }}</td>
                        <td class="px-6 py-4">{{ $payment->client_name }}</td>
                        <td class="px-6 py-4">{{ number_format($payment->amount, 2) }}</td>
                        <td class="px-6 py-4">{{ number_format($payment->amount_due, 2) }}</td>
                        <td class="px-6 py-4">{{ $payment->payment_method }}</td>
                        <td class="px-6 py-4">{{ $payment->status }}</td>
                        <td class="px-6 py-4">{{ $payment->payment_date->format('d/m/Y') }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="7" class="px-6 py-4 text-center">No payments found.</td>
                    </tr>
                @endforelse
            </tbody>
            <tfoot class="bg-gray-100 font-bold">
                <tr>
                    <td colspan="2" class="px-6 py-3 text-right">Total:</td>
                    <td class="px-6 py-3">{{ number_format($payments->sum('amount'), 2) }}</td>
                    <td class="px-6 py-3">{{ number_format($payments->sum('amount_due'), 2) }}</td>
                    <td colspan="3"></td>
                </tr>
            </tfoot>
        </table>
    </div>
</main>
@endsection

